 ; Ŀ
 ;   Bx - draw a box by input height and width or by dragging.             
 ;   Renamed from Box to avoid conflict with the (later) Acad command.     
 ;   Copyright 1994, 1996, 2006, 2010 by Rocket Software Ltd.              
 ;   The Turing test is a mistake - it assumes that a human being          
 ;   can pass for an intelligence.                                         
 ; 

 ; Ŀ
 ;   Bmx - scale the box from inches to mm.                                
 ; 
 (DEFUN C:BMX ()
  (c:bx)
  (command ".scale" (entlast) "" apa 25.4)
 (princ))

 ; Ŀ
 ;   Bx.                                                                   
 ; 
 (DEFUN C:BX ( / blip osmo *error* cc bb dd htp wdthp)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq blip (getvar "blipmode"))
  (setvar "blipmode" 0)
  (setq osmo (getvar "osmode"))
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
  (defun *error* (shk)
   (if osmo (setvar "osmode" osmo))
   (if blip (setvar "blipmode" blip))
   (command "undo" "end")
   (if shk (write-line shk))
  (princ))
 ; Ŀ
 ;   Get some points.                                                      
 ; 
  (setvar "osmode" 33)
  (setq apa (getpoint "First corner:"))  ; not local in case bmx is using it
 ; Ŀ
 ;   See if the user wants to input a second corner.                       
 ; 
  (if (setq cc (getcorner apa "\nOpposite corner or <Return> to specify: "))
     (progn
          (setq bb (cons (car cc) (cdr apa)))
          (setq dd (cons (car apa) (cdr cc)))
          (setvar "osmode" 0)
          (command "pline" apa bb cc dd "c"))
 ; Ŀ
 ;   Or get two distances.                                                 
 ; 
     (progn
          (if (or (= (type wdth) 'INT) (= (type wdth) 'REAL))
              (progn
                   (setq wdthp (getdist apa (strcat "\nWidth <"
                                                   (rtos wdth 2 2) ">: ")))
                   (if wdthp (setq wdth wdthp)))
              (setq wdth (getdist apa "\nWidth: ")))
          (if (or (and (/= (type ht) 'INT) (/= (type ht) 'REAL))
                  wdthp)
              (setq ht wdth))
          (setq htp (getdist apa (strcat "\nand height <"
                                        (rtos ht 2 2) ">: ")))
          (if htp (setq ht htp))
          (setvar "osmode" 0)
          (command "pline" apa (polar apa 0 wdth)
                              (polar (polar apa 0 wdth) (* pi 1.5) ht)
                              (polar apa (* pi 1.5) ht)
                              "c")))
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (*error* ())
 (princ))